/*
  Analog_Keypad.h

  Open Source 2016, Bent Arnoldsen
  UC Holstebro - Tekniks Gymnasium

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef ANALOG_KEYPAD_H
#define ANALOG_KEYPAD_H

// Arduino versioning.
#if defined(ARDUINO) && ARDUINO >= 100
#include "Arduino.h"
#else
#include "WProgram.h"
#endif

typedef unsigned int uint;
typedef unsigned long ulong;

const char NO_KEY = (char)255;

//class Analog_Keypad Interface
class Analog_Keypad {
public:

	// Two different constructors for the class
	Analog_Keypad(char *userKeyMap, byte analogPin, byte numKeys);
	Analog_Keypad(char *userKeyMap, byte analogPin, byte numKeys, byte numAccept);

	// Basic interface
	char getKey();
	void begin();

	// Extended interface
	bool isPressed(char keyChar);
	void setDebounceTime(uint debounce);
	void setHoldTime(uint hold);
	void setHoldMode(bool mode);
	void setNumAccept(byte count);
	char waitForKey();

private:
	unsigned long startTime;
	char *keymap;
    byte inputPin;
    byte numOfKeys;
	unsigned long debounceTime;
	unsigned long holdTime;
	bool repeating;
	bool holdMode;
	char thisKey;
	char lastKey;
	byte numAccept;
	byte numPolls;
	uint keyOffset;
	uint segment;

	byte getKeyNum();

};

#endif

/*
|| @changelog
*/
