// Testmodule for Analog Keypad

//  Open Source 2016, Bent Arnoldsen
//  UC Holstebro - Tekniks Gymnasium

//  Testing basic functionality 

#include <Analog_Keypad.h>

const byte NUM_KEYS = 12;
const byte KEYB_PIN = A2;
char hexaKeys[NUM_KEYS] = 
  {'0','1','2','3','4','5','6','7','8','9','A','B'};

//initialize an instance of class Analog_Keypad
Analog_Keypad myKeypad = Analog_Keypad(hexaKeys, KEYB_PIN, NUM_KEYS); 


void setup() {
  Serial.begin(9600);
  myKeypad.begin();
  // For test of the key hold functionallty
  // myKeypad.setHoldMode(true);
  // myKeypad.setDebounceTime(50);
  // myKeypad.setHoldTime(300);
  // For test of the number of similar readings before accept
  // myKeypad.setNumAccept(200);
  Serial.println("Analog Keyboard Test Program");
  Serial.println("Holstebro HTX - Bent Arnoldsen");
  Serial.println();
}


void loop() {
  char key = myKeypad.getKey(); // Poll for a key value
  if (key != NO_KEY) {  // Are a valid key pressed
    Serial.println(key);
  }
  // Testing isPressed function
  if (key == '4') {
    while (myKeypad.isPressed('4')) {
      Serial.print(analogRead(A2));
      Serial.print(" ");
    }
  }
  // Testing waitForKey function
  if (key == '9') {
    key = myKeypad.waitForKey();
    Serial.print(key);
    Serial.println(" was waited for");
  }
  delay(2);  // Only a short delay, because of check for 5 similar keyreadings before returning valid key
}
